﻿
namespace Framework.Web.UI.CompositeControls
{
    /// <summary>
    /// GridViewPagerのRowUpdatingイベントのイベント引数
    /// </summary>
    public class GridViewPagerUpdateEventArgs : System.EventArgs
    {
        /// <summary>
        /// イベントをキャンセルする場合はtrueをセットします
        /// </summary>
        public bool Cancel = false;

        /// <summary>
        /// 更新行のDataKey
        /// </summary>
        public System.Web.UI.WebControls.DataKey DataKey;

        /// <summary>
        /// 更新行の行オブジェクト
        /// </summary>
        public System.Web.UI.WebControls.GridViewRow GridViewRow;

        /// <summary>
        /// 更新行の行インデックス
        /// </summary>
        public int RowIndex = -1;

        /// <summary>
        /// 更新前データ
        /// </summary>
        public System.Data.DataRowView OldValues;

        /// <summary>
        /// 更新後データ
        /// </summary>
        public System.Data.DataRowView NewValues;

    }

    /// <summary>
    /// GridViewPagerのRowUpdatingイベント
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public delegate void GridViewPagerUpdateEventHandler(object sender, GridViewPagerUpdateEventArgs e);
}
